export const ALPHABET = ['#', ...'ABCDEFGHIJKLMNOPQRSTUVWXYZ'];
export const strengthLevels = { '0.170000': 'Low', '0.370000': 'Normal', '0.670000': 'High' };
export const strengthValues = { 'Low': '0.170000', 'Normal': '0.370000', 'High': '0.670000' };
export const aspectLevels = { '0': '4:3', '1': '16:9', '21': 'Pixel Perfect' };
export const aspectValues = { '4:3': '0', '16:9': '1', 'Pixel Perfect': '21' };
export const relayOptions = [
    { labelKey: "relay_disabled", server: "", enabled: "false" },
    { labelKey: "relay_na", server: "nyc", enabled: "true" },
    { labelKey: "relay_weu", server: "madrid", enabled: "true" },
    { labelKey: "relay_sa", server: "saopaulo", enabled: "true" },
    { labelKey: "relay_sea", server: "singapore", enabled: "true" },
    { labelKey: "relay_ea", server: "chuncheon", enabled: "true" },
];
export const RETROARCH_LANG_MAP = { 'en': '0', 'es': '3', 'fr': '2', 'pt': '7', 'de': '4', 'it': '5' };
export const availableRegions = ['Show All', 'USA Only', 'Other'];
export const availableLanguages = [{ code: 'en', name: 'English' }, { code: 'es', name: 'Español' }, { code: 'fr', name: 'Français' }, { code: 'pt', name: 'Português' }, { code: 'de', name: 'Deutsch' }, { code: 'it', name: 'Italiano' }];
export const REPEAT_DELAY = 100;
export const INITIAL_REPEAT_DELAY = 250;
export const ATTRACT_MODE_TIMEOUT = 90000; 
export const ATTRACT_MODE_SCROLL_INTERVAL = 10000; 
export const GRID_COLUMNS = 6;

export const DEFAULT_APP_SETTINGS = {
    bgmVolumeLevel: 8,
    bgmPath: "default",
    language: "en",
    region: "Show All", 
    attractModeEnabled: "true",
    startFullscreen: true,
};

export const DEFAULT_RETROARCH_SETTINGS = {
    savestate_auto_index: "true",
    savestate_auto_load: "true",
    savestate_max_keep: "4",
    aspect_ratio_index: "0",
    video_fullscreen: "true",
    video_windowed_fullscreen: "true",
    input_overlay_enable: "true",
    input_overlay_opacity: "0.370000",
    input_hold_fast_forward_axis: "nul",
    rewind_enable: "false",
    input_hold_fast_forward_axis: "nul",
    cheevos_enable: "false",
    cheevos_username: "",
    cheevos_password: "",
    user_language: "0"
};

export const IN_GAME_DEFAULTS = {
    savestate_auto_index: DEFAULT_RETROARCH_SETTINGS.savestate_auto_index,
    savestate_auto_load: DEFAULT_RETROARCH_SETTINGS.savestate_auto_load,
    savestate_max_keep: DEFAULT_RETROARCH_SETTINGS.savestate_max_keep,
    aspect_ratio_index: DEFAULT_RETROARCH_SETTINGS.aspect_ratio_index,
    video_fullscreen: DEFAULT_RETROARCH_SETTINGS.video_fullscreen,
    input_overlay_enable: DEFAULT_RETROARCH_SETTINGS.input_overlay_enable,
    input_overlay_opacity: DEFAULT_RETROARCH_SETTINGS.input_overlay_opacity,
    rewind_enable: DEFAULT_RETROARCH_SETTINGS.rewind_enable,
    input_hold_fast_forward_axis: DEFAULT_RETROARCH_SETTINGS.input_hold_fast_forward_axis,
};


export let games = [];
export let masterGameList = [];
export let selectedIndex = 0;
export let APP_PATHS = {};
export let UI_URLS = {};
export let twoPlayerGames = [];
export let saveStateCache = {};
export let currentSaveStates = [];


export let isStartMenuOpen = false;
export let startMenuSelectionIndex = 0;
export let isSystemOptionsMenuOpen = false;
export let systemOptionsSelectionIndex = 0;
export let isIngameOptionsOpen = false;
export let ingameOptionsSelectionIndex = 0;
export let isGeneralOptionsOpen = false;
export let generalOptionsSelectionIndex = 0;
export let isNetworkFeaturesOpen = false;
export let networkFeaturesSelectionIndex = 0;
export let isLobbyOpen = false;
export let lobbyGames = [];
export let lobbySelectionIndex = 0;
export let lobbyMenuOrigin = null;
export let isPowerMenuOpen = false;
export let powerMenuSelectionIndex = 0;
export let isSaveStatesMenuOpen = false;
export let saveStatesSlotSelectionIndex = 0;
export let saveStatesActionSelectionIndex = 0;
export let saveStatesNavRow = 0;
export let isNetplayUsernameOpen = false;
export let netplayUsernameSelectionIndex = 0;
export let isRaLoginOpen = false;
export let raLoginSelectionIndex = 0;


export let isProcessActive = false;
export let appSettings = {};
export let availableBgmTracks = [];
export let currentTranslations = {};
export let currentRelayIndex = 0;
export let initialRelayIndex = 0;
export let inactivityTimer = null;
export let attractModeInterval = null;
export let attractSonicInterval = null;
export let attractPlaylist = [];
export let attractPlaylistIndex = 0;


export let focusedElement = 'grid'; 
export let actionIconIndex = 0; 


export function setInitialData(data) { masterGameList = data.games; games = [...masterGameList]; twoPlayerGames = data.twoPlayerGames; availableBgmTracks = data.bgmTracks; APP_PATHS = data.appPaths; UI_URLS = data.uiUrls; }
export function setInitialSettings(settings) { appSettings = { ...DEFAULT_APP_SETTINGS, ...DEFAULT_RETROARCH_SETTINGS, ...settings }; }
export function setSelectedIndex(value) { selectedIndex = value; }
export function setCurrentSaveStates(value) { currentSaveStates = value; }
export function setProcessActive(value) { isProcessActive = value; }
export function setCurrentTranslations(value) { currentTranslations = value; }
export function setCurrentRelayIndex(value) { currentRelayIndex = value; }
export function setInitialRelayIndex(value) { initialRelayIndex = value; }
export function setInactivityTimer(value) { inactivityTimer = value; }
export function setAttractModeInterval(value) { attractModeInterval = value; }
export function setAttractSonicInterval(value) { attractSonicInterval = value; }
export function setAttractPlaylist(value) { attractPlaylist = value; }
export function setAttractPlaylistIndex(value) { attractPlaylistIndex = value; }


export function setFocusedElement(value) { focusedElement = value; }
export function setActionIconIndex(value) { actionIconIndex = value; }

export function applyRegionFilter() {
    const regionSetting = appSettings.region;

    if (regionSetting === 'USA Only') {
        games = masterGameList.filter(g => g.zipName.includes('(USA)'));
    } else if (regionSetting === 'Other') {
        games = masterGameList.filter(g => {
            const regionMatch = g.zipName.match(/\(([^)]+)\)/);
            
            
            if (!regionMatch) return false;

            const regionTag = regionMatch[1]; 
            const regions = regionTag.split(',').map(r => r.trim());

            
            const isExclusivelyUSA = regions.length === 1 && regions[0] === 'USA';

            
            return !isExclusivelyUSA;
        });
    } else { 
        games = [...masterGameList];
    }
}

// Modal Setters
export function setStartMenuOpen(value) { isStartMenuOpen = value; }
export function setStartMenuSelectionIndex(value) { startMenuSelectionIndex = value; }
export function setSystemOptionsMenuOpen(value) { isSystemOptionsMenuOpen = value; }
export function setSystemOptionsSelectionIndex(value) { systemOptionsSelectionIndex = value; }
export function setIngameOptionsOpen(value) { isIngameOptionsOpen = value; }
export function setIngameOptionsSelectionIndex(value) { ingameOptionsSelectionIndex = value; }
export function setGeneralOptionsOpen(value) { isGeneralOptionsOpen = value; }
export function setGeneralOptionsSelectionIndex(value) { generalOptionsSelectionIndex = value; }
export function setNetworkFeaturesOpen(value) { isNetworkFeaturesOpen = value; }
export function setNetworkFeaturesSelectionIndex(value) { networkFeaturesSelectionIndex = value; }
export function setLobbyOpen(value) { isLobbyOpen = value; }
export function setLobbyGames(value) { lobbyGames = value; }
export function setLobbySelectionIndex(value) { lobbySelectionIndex = value; }
export function setLobbyMenuOrigin(value) { lobbyMenuOrigin = value; }
export function setPowerMenuOpen(value) { isPowerMenuOpen = value; }
export function setPowerMenuSelectionIndex(value) { powerMenuSelectionIndex = value; }
export function setSaveStatesMenuOpen(value) { isSaveStatesMenuOpen = value; }
export function setSaveStatesSlotSelectionIndex(value) { saveStatesSlotSelectionIndex = value; }
export function setSaveStatesActionSelectionIndex(value) { saveStatesActionSelectionIndex = value; }
export function setSaveStatesNavRow(value) { saveStatesNavRow = value; }
export function setNetplayUsernameOpen(value) { isNetplayUsernameOpen = value; }
export function setNetplayUsernameSelectionIndex(value) { netplayUsernameSelectionIndex = value; }
export function setRaLoginOpen(value) { isRaLoginOpen = value; }
export function setRaLoginSelectionIndex(value) { raLoginSelectionIndex = value; }